"use client"

import * as React from "react"

import {
  Sidebar,
  SidebarContent,
  SidebarFooter,
  SidebarHeader,
  SidebarMenu,
  SidebarMenuItem,
} from "@/components/ui/sidebar"
import { routing } from "@/config/site"
import { isPageCollection } from "@/lib/is"
import { ApplicationPlatform } from "./application.platform"
import { NavigationActions } from "./navigation.actions"
import { NavigationPageCollection } from "./navigation.page-collection"
import { NavigationPage } from "./navigation.page"
import { ApplicationThemeToggle } from "./application.theme-toggle"

export function ApplicationSidebar({ userItem, notification, ...props }: React.ComponentProps<typeof Sidebar> & { userItem?: React.ReactNode, notification?: React.ReactNode }) {
  return (
    <Sidebar variant="inset" {...props}>
      <SidebarHeader>
        <ApplicationPlatform />
      </SidebarHeader>
      <SidebarContent className="gap-0">
        {notification}

        <SidebarMenu className="gap-0">
          {routing.navigation.map((item) => (
            isPageCollection(item)
              ? (
                <NavigationPageCollection
                  key={item.title}
                  {...item}
                />
              ) : (
                <NavigationPage
                  key={item.title}
                  {...item}
                />
              )
          ))}
        </SidebarMenu>

        <NavigationActions items={routing.actions} className="mt-auto" />
      </SidebarContent>

      <SidebarFooter>
        <SidebarMenu>
          <SidebarMenuItem className={
            !!userItem
              ? "grid grid-cols-[1fr,_auto] items-center gap-1"
              : "grid items-center gap-1"
          }>
            {userItem}
            <ApplicationThemeToggle
              className={
                !!userItem
                  ? ""
                  : "w-full"
              }
            />
          </SidebarMenuItem>
        </SidebarMenu>
      </SidebarFooter>
    </Sidebar>
  )
}

